<?php

namespace App\Models;

use Cviebrock\EloquentSluggable\Sluggable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LandingSection extends Model
{
    use HasFactory, Sluggable;

    protected $fillable = [
        'title',
        'limit',
        'status',
        'sortable',
    ];

    public function sluggable(): array
    {
        return [
            'slug' => [
                'source' => ['title'],
            ],
        ];
    }

    public function genres()
    {
        return $this->belongsToMany(Genre::class, 'landing_sections_genres');
    }

    public function posts()
    {
        $genreIds = $this->genres->pluck('id');
        return \App\Models\Post::where('status', 'publish')
            ->whereHas('genres', function ($query) use ($genreIds) {
                $query->whereIn('genres.id', $genreIds);
            })
            ->limit($this->limit);
    }
}
