<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('landing_sections_genres', function (Blueprint $table) {
            $table->id();
            $table->foreignId('landing_section_id')->index()->constrained('landing_sections')->cascadeOnDelete();
            $table->foreignId('genre_id')->index()->constrained('genres')->cascadeOnDelete();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('landing_sections_genres');
    }
};
