@extends('layouts.admin')
@section('content')
    <form method="post" action="{{ route('admin.landing-alert.update') }}" enctype="multipart/form-data">
        <div class="max-w-7xl mx-auto w-full py-6">
            @csrf
            
            <div class="border-b pb-3 border-gray-100 dark:border-gray-800">
                <ul class="flex gap-x-4 whitespace-nowrap overflow-x-auto sm:overflow-x-visible sm:p-2 lg:p-0">
                    <li>
                        <a href="#"
                           class="w-full py-3 px-6 inline-flex justify-center items-center gap-4 text-sm font-medium text-center text-gray-500 rounded-lg hover:bg-gray-50 relative after:absolute after:-bottom-3 after:rounded-full after:left-0 after:right-0 after:h-1 dark:text-gray-400 dark:hover:text-gray-300 dark:hover:bg-gray-800 after:bg-primary-500 text-primary-500 hover:bg-transparent dark:text-primary-400 dark:!text-white dark:hover:bg-transparent">
                            {{__('General')}}
                        </a>
                    </li>
                </ul>
            </div>
            
            <div class="py-6">
                <div class="grid grid-cols-1 lg:grid-cols-12 gap-x-10 gap-y-2">
                    <div class="lg:col-span-12">
                        <div class="mb-5">
                            <div class="flex items-center space-x-4">
                                <x-form.switch type="checkbox" id="landing_alert_enabled" name="landing_alert_enabled" value="1"
                                               :checked="config('settings.landing_alert_enabled') == '1' ? true : false"/>
                                <x-form.label for="landing_alert_enabled" class="lg:mb-0 cursor-pointer font-normal"
                                              :value="__('Enable Landing Alert Modal')"/>
                            </div>
                            <p class="mt-2 text-sm text-gray-500 dark:text-gray-400">
                                {{__('When enabled, users will see a popup modal when visiting the root URL.')}}
                            </p>
                        </div>
                    </div>

                    <div class="lg:col-span-12">
                        <hr class="my-6 border-gray-100 dark:border-gray-800">
                    </div>

                    <div class="lg:col-span-12">
                        <div class="mb-5">
                            <x-form.label for="landing_alert_title" :value="__('Alert Title')"/>
                            <x-form.input id="landing_alert_title" name="landing_alert_title" type="text" class="mt-1 block w-full"
                                          value="{{ old('landing_alert_title', config('settings.landing_alert_title')) }}"
                                          placeholder="{{__('Download Our App')}}"/>
                            <x-form.error class="mt-2" :messages="$errors->get('landing_alert_title')"/>
                        </div>
                    </div>

                    <div class="lg:col-span-12">
                        <div class="mb-5">
                            <x-form.label for="landing_alert_description" :value="__('Alert Description')"/>
                            <x-form.textarea name="landing_alert_description"
                                             placeholder="{{__('Get the best movie experience with our mobile app')}}">{!! old('landing_alert_description', config('settings.landing_alert_description')) !!}</x-form.textarea>
                            <x-form.error class="mt-2" :messages="$errors->get('landing_alert_description')"/>
                        </div>
                    </div>

                    <div class="lg:col-span-6">
                        <div class="mb-5">
                            <x-form.label for="landing_alert_button_text" :value="__('Button Text')"/>
                            <x-form.input id="landing_alert_button_text" name="landing_alert_button_text" type="text" class="mt-1 block w-full"
                                          value="{{ old('landing_alert_button_text', config('settings.landing_alert_button_text')) }}"
                                          placeholder="{{__('Download Now')}}"/>
                            <x-form.error class="mt-2" :messages="$errors->get('landing_alert_button_text')"/>
                        </div>
                    </div>

                    <div class="lg:col-span-6">
                        <div class="mb-5">
                            <x-form.label for="landing_alert_button_link" :value="__('Button Link')"/>
                            <x-form.input id="landing_alert_button_link" name="landing_alert_button_link" type="text" class="mt-1 block w-full"
                                          value="{{ old('landing_alert_button_link', config('settings.landing_alert_button_link')) }}"
                                          placeholder="{{__('https://')}}"/>
                            <x-form.error class="mt-2" :messages="$errors->get('landing_alert_button_link')"/>
                        </div>
                    </div>

                    <div class="lg:col-span-12">
                        <hr class="my-6 border-gray-100 dark:border-gray-800">
                    </div>

                    <div class="lg:col-span-12">
                        <div class="mb-5">
                            <x-form.label :value="__('Feature Icons')"/>
                            <p class="text-sm text-gray-500 dark:text-gray-400 mb-4">
                                {{__('Add feature icons that will be displayed in the alert modal.')}}
                                <br>
                                <strong>{{__('Sprite Icons:')}}</strong> {{__('Use icon names like: film, star, download')}}
                                <br>
                                <strong>{{__('Font Awesome:')}}</strong> {{__('Use full classes like: fas fa-home, far fa-star, fab fa-facebook')}}
                            </p>

                            <div id="features-container" class="space-y-4">
                                @php
                                    $features = json_decode(config('settings.landing_alert_features', '[]'), true);
                                    if (empty($features)) {
                                        $features = [
                                            ['icon' => 'film', 'text' => '4K Video'],
                                            ['icon' => 'ban', 'text' => 'No Ads'],
                                            ['icon' => 'download', 'text' => 'Offline Download'],
                                            ['icon' => 'star', 'text' => 'Exclusive Movies'],
                                        ];
                                    }
                                @endphp

                                @foreach($features as $index => $feature)
                                    <div class="feature-row grid grid-cols-1 lg:grid-cols-12 gap-4 items-end">
                                        <div class="lg:col-span-4">
                                            <x-form.label :value="__('Icon Name')"/>
                                            <x-form.input name="features[{{$index}}][icon]" type="text" class="mt-1 block w-full"
                                                          value="{{ old('features.'.$index.'.icon', $feature['icon']) }}"
                                                          placeholder="{{__('film')}}"/>
                                        </div>
                                        <div class="lg:col-span-6">
                                            <x-form.label :value="__('Feature Text')"/>
                                            <x-form.input name="features[{{$index}}][text]" type="text" class="mt-1 block w-full"
                                                          value="{{ old('features.'.$index.'.text', $feature['text']) }}"
                                                          placeholder="{{__('4K Video')}}"/>
                                        </div>
                                        <div class="lg:col-span-2 mt-6">
                                            <button type="button" class="w-full px-4 py-2 bg-red-500 hover:bg-red-600 text-white rounded-lg text-sm font-medium transition"
                                                    onclick="this.closest('.feature-row').remove()">
                                                {{__('Remove')}}
                                            </button>
                                        </div>
                                    </div>
                                @endforeach
                            </div>

                            <button type="button" id="add-feature-btn"
                                    class="mt-4 px-4 py-2 bg-gray-200 hover:bg-gray-300 dark:bg-gray-700 dark:hover:bg-gray-600 text-gray-800 dark:text-white rounded-lg text-sm font-medium transition">
                                {{__('Add Feature')}}
                            </button>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="mt-6">
                <x-form.primary class="w-full max-w-xs">{{__('Save Changes')}}</x-form.primary>
            </div>
        </div>
    </form>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            let featureIndex = {{ count($features) }};

            document.getElementById('add-feature-btn').addEventListener('click', function() {
                const container = document.getElementById('features-container');
                const newRow = document.createElement('div');
                newRow.className = 'feature-row grid grid-cols-1 lg:grid-cols-12 gap-4 items-end';
                newRow.innerHTML = `
                    <div class="lg:col-span-4">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{__('Icon Name')}}</label>
                        <input type="text" name="features[${featureIndex}][icon]" class="mt-1 block w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-primary-500 focus:ring-primary-500"
                               placeholder="{{__('film')}}">
                    </div>
                    <div class="lg:col-span-6">
                        <label class="block text-sm font-medium text-gray-700 dark:text-gray-300 mb-1">{{__('Feature Text')}}</label>
                        <input type="text" name="features[${featureIndex}][text]" class="mt-1 block w-full rounded-lg border-gray-300 dark:border-gray-600 dark:bg-gray-700 dark:text-white shadow-sm focus:border-primary-500 focus:ring-primary-500"
                               placeholder="{{__('4K Video')}}">
                    </div>
                    <div class="lg:col-span-2 mt-6">
                        <button type="button" class="w-full px-4 py-2 bg-red-500 hover:bg-red-600 text-white rounded-lg text-sm font-medium transition"
                                onclick="this.closest('.feature-row').remove()">
                            {{__('Remove')}}
                        </button>
                    </div>
                `;
                container.appendChild(newRow);
                featureIndex++;
            });
        });
    </script>
@endsection
