@extends('layouts.admin')
@section('content')
    <div class="max-w-xl mx-auto w-full">
        <!-- Grid -->
        <x-form.layout>
            <!-- End Grid -->
            <form method="post">
                @csrf
                @if(isset($listing))
                    @method('PUT')
                @endif
                <div class="mb-5">
                    <x-form.label for="title" :value="__('Title')"/>
                    <x-form.input id="title" class="block mt-1 w-full" type="text" name="title"
                                  value="{{ old('title', isset($listing) ? $listing->title : '') }}"
                                  required placeholder="{{__('Title')}}"/>
                    <x-form.error :messages="$errors->get('title')" class="mt-2"/>
                    <div class="flex items-center text-xs mt-2">
                        <span class="font-medium text-gray-500 mr-2">Permalink</span>
                        <span class="text-gray-500">{{url('/').'/'}}</span>
                        <input type="text" name="slug"
                               class="font-medium border-0 py-0 text-xs px-1 inline-flex text-primary-500 bg-transparent focus:ring-0 w-auto placeholder-gray-300 dark:placeholder-gray-500"
                               placeholder="slug"
                               value="{{ old('slug', isset($listing) ? $listing->slug : '') }}">
                    </div>
                </div>
                <div class="mb-5">
                    <x-form.label for="genres" :value="__('Genre')"/>
                    <div class="relative flex w-full">
                        <select name="genres[]" placeholder="Choose" class="selectpicker" multiple id="genres" required>
                            <option value="">Choose</option>
                            @foreach($genres as $genre)
                                <option data-text="{{$genre->title}}" value="{{$genre->id}}"
                                        @if(isset($listing->id) AND $listing->genres()->find($genre->id)) selected @endif>{{$genre->title}}</option>
                            @endforeach
                        </select>
                    </div>
                    <x-form.error :messages="$errors->get('genres')" class="mt-2"/>
                    <p class="mt-1 text-xs text-gray-500">{{__('Select one or more genres. This section will display movies from the selected genres.')}}</p>
                </div>
                <div class="mb-5">
                    <x-form.label for="limit" :value="__('Limit')"/>
                    <x-form.input id="limit" class="block mt-1 w-full" type="number" name="limit"
                                  value="{{ old('limit', isset($listing) ? $listing->limit : 8) }}"
                                  required min="1" max="50" placeholder="{{__('Limit')}}"/>
                    <x-form.error :messages="$errors->get('limit')" class="mt-2"/>
                    <p class="mt-1 text-xs text-gray-500">{{__('Number of movies to display in this section')}}</p>
                </div>
                <div class="mb-5">
                    <x-form.label for="status" :value="__('Status')"/>
                    <select name="status" id="status" class="mt-1 block w-full border-gray-300 rounded-md shadow-sm focus:border-primary-500 focus:ring-primary-500 dark:bg-gray-800 dark:border-gray-700 dark:text-gray-300" required>
                        <option value="active" {{ old('status', isset($listing) ? $listing->status : 'active') == 'active' ? 'selected' : '' }}>
                            {{__('Active')}}
                        </option>
                        <option value="inactive" {{ old('status', isset($listing) ? $listing->status : 'active') == 'inactive' ? 'selected' : '' }}>
                            {{__('Inactive')}}
                        </option>
                    </select>
                    <x-form.error :messages="$errors->get('status')" class="mt-2"/>
                </div>
                <div class="mb-5">
                    <x-form.label for="sortable" :value="__('Sortable')"/>
                    <x-form.input id="sortable" class="block mt-1 w-full" type="number" name="sortable"
                                  value="{{ old('sortable', isset($listing) ? $listing->sortable : 0) }}"
                                  placeholder="{{__('Sortable')}}"/>
                    <x-form.error :messages="$errors->get('sortable')" class="mt-2"/>
                    <p class="mt-1 text-xs text-gray-500">{{__('Lower numbers appear first')}}</p>
                </div>
                <x-form.primary class="w-full">{{__('Save change')}}</x-form.primary>
            </form>
        </x-form.layout>
    </div>
    @push('javascript')
        <script src="{{asset('static/js/jquery.js')}}" type="text/javascript"></script>
        <script src="{{asset('static/js/select.js')}}" type="text/javascript"></script>
        <script>
            $('.selectpicker').selectize({create: false})
        </script>
    @endpush
@endsection
