<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>" class="dark"
      dir="<?php echo e(app()->getLocale() == 'ar' ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    <title><?php if(isset($config['title'])): ?>
            <?php echo e($config['title']); ?>

        <?php else: ?>
            <?php echo e(config('settings.title')); ?>

        <?php endif; ?></title>

    <meta itemprop="name"
          content="<?php if(isset($config['title'])): ?><?php echo e($config['title']); ?><?php else: ?><?php echo e(config('settings.title')); ?><?php endif; ?>">
    <meta itemprop="description"
          content="<?php if(isset($config['description'])): ?><?php echo e($config['description']); ?><?php else: ?><?php echo e(config('settings.description')); ?><?php endif; ?>">
    <?php if(!empty($config['image'])): ?>
        <meta itemprop="image" content="<?php echo e($config['image']); ?>">
    <?php endif; ?>

    <meta property="og:title"
          content="<?php if(isset($config['title'])): ?><?php echo e($config['title']); ?><?php else: ?><?php echo e(config('settings.title')); ?><?php endif; ?>">
    <meta property="og:description"
          content="<?php if(isset($config['description'])): ?><?php echo e($config['description']); ?><?php else: ?><?php echo e(config('settings.description')); ?><?php endif; ?>">
    <?php if(!empty($config['image'])): ?>
        <meta property="og:image" content="<?php echo e($config['image']); ?>"/>
    <?php endif; ?>
    <meta property="og:url" content="<?php echo e(url()->current()); ?>">
    <meta property="og:locale" content="<?php echo e(app()->getLocale().'_'.strtoupper(app()->getLocale())); ?>"/>
    <meta property="og:type" content="article"/>
    <meta name="twitter:card" content="summary_large_image">

    <link rel="canonical" href="<?php echo e(url()->current()); ?>"/>

    <?php echo $__env->make('partials.head', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scriptConfig(); ?>

</head>
<body class="min-h-screen dark:bg-gray-950 flex flex-col relative" x-cloak="" x-data="{ searchOpen: false,loading:false,'sidebarToggle': false,compactToggle: localStorage.getItem('compactToggle') === 'true', cookiePolicy: localStorage.getItem('cookiePolicy'), promote: localStorage.getItem('promote')}"
    x-init="$watch('cookiePolicy', val => {
  localStorage.setItem('cookiePolicy', val);
}) ; $watch('promote', val => {
  localStorage.setItem('promote', val);
}); $watch('compactToggle', val => {
  localStorage.setItem('compactToggle', val);
})">
        <?php echo $__env->make('partials.navbar',['search' => true], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

            <?php if(!config('settings.layout') || config('settings.layout') == 'horizontal'): ?>
                <?php echo $__env->make('partials.sidenav', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php endif; ?>
            <div class="">
                <div
                    class="flex-1 <?php if(!config('settings.layout') || config('settings.layout') == 'horizontal'): ?><?php echo e('lg:ml-64 rtl:lg:ml-o rtl:lg:mr-64'); ?><?php endif; ?>"
                    :class="compactToggle ? 'lg:!ml-20 rtl:lg:!ml-0 rtl:lg:!mr-0' : ''">
                    <?php echo $__env->yieldContent('content'); ?>

                </div>
                <div
                    class="<?php if(!config('settings.layout') || config('settings.layout') == 'horizontal'): ?><?php echo e('lg:ml-64 rtl:lg:ml-o rtl:lg:mr-64'); ?><?php endif; ?> mt-auto"
                    :class="compactToggle ? 'lg:!ml-20 rtl:lg:!ml-0 rtl:lg:!mr-0' : ''">
                    <?php echo $__env->make('partials.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </div>
            </div>


<?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('search-component', []);

$__html = app('livewire')->mount($__name, $__params, '3xs3zwv', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
<script src="<?php echo e(asset('static/js/lazysizes.js')); ?>"></script>
<?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('notify-component', []);

$__html = app('livewire')->mount($__name, $__params, '1GgKu1V', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
<?php echo $__env->yieldPushContent('javascript'); ?>
<?php echo $__env->yieldPushContent('after-body'); ?>
<?php if (isset($component)) { $__componentOriginal339c7fedf680433726dbafc2f156956f = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal339c7fedf680433726dbafc2f156956f = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.ui.toast','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? (array) $attributes->getIterator() : [])); ?>
<?php $component->withName('ui.toast'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag && $constructor = (new ReflectionClass(Illuminate\View\AnonymousComponent::class))->getConstructor()): ?>
<?php $attributes = $attributes->except(collect($constructor->getParameters())->map->getName()->all()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal339c7fedf680433726dbafc2f156956f)): ?>
<?php $attributes = $__attributesOriginal339c7fedf680433726dbafc2f156956f; ?>
<?php unset($__attributesOriginal339c7fedf680433726dbafc2f156956f); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal339c7fedf680433726dbafc2f156956f)): ?>
<?php $component = $__componentOriginal339c7fedf680433726dbafc2f156956f; ?>
<?php unset($__componentOriginal339c7fedf680433726dbafc2f156956f); ?>
<?php endif; ?>
</body>
</html>
<?php /**PATH C:\Users\mdeas\Downloads\Compressed\MovieSite\resources\views/layouts/app.blade.php ENDPATH**/ ?>