
<div class="pb-6 lg:pb-10 pt-3">
    <div class="flex items-center justify-between mb-4">
        <h2 class="text-xl lg:text-2xl font-semibold text-gray-900 dark:text-white">
            <?php echo e(__('Trending Now')); ?>

        </h2>
        <a href="<?php echo e(route('movies')); ?>" class="text-sm font-medium text-primary-500 hover:text-primary-600 dark:text-primary-400 dark:hover:text-primary-300 flex items-center gap-1">
            <?php echo e(__('See all')); ?>

            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"/>
            </svg>
        </a>
    </div>
    <div class="flex gap-x-6 w-full overflow-x-auto lg:overflow-x-visible p-3 lg:p-0">
        <?php $__currentLoopData = $listings['featured']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $featured): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <a href="<?php echo e(route($featured->type,$featured->slug)); ?>" class="relative text-center w-20 lg:w-28 cursor-pointer">
            <div
                class="w-20 lg:w-24 h-20 lg:h-24 mx-auto relative rounded-full bg-gray-100 dark:bg-gray-600 ring-4 ring-offset-4 ring-offset-gray-950 ring-primary-500">
                <img src="<?php echo e($featured->storyurl); ?>" class="absolute w-full h-full object-cover rounded-full">
            </div>
            <div class="py-5">
                <h3 class="text-xs lg:text-sm text-gray-700 dark:text-gray-200 font-medium line-clamp-1"><?php echo e($featured->title); ?></h3>
                <div class="text-xs text-gray-500 dark:text-gray-500 font-medium line-clamp-1 capitalize"><?php echo e($featured->type == 'movie' ? __('Movie') : __('TV Show')); ?></div>
            </div>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php /**PATH C:\Users\mdeas\Downloads\Compressed\MovieSite\resources\views/home/partials/featured.blade.php ENDPATH**/ ?>